/*
 * From Header Field Name Parsing Macros
 *
 * Copyright (C) 2001-2003 FhG Fokus
 *
 * This file is part of opensips, a free SIP server.
 *
 * opensips is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version
 *
 * opensips is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */


#ifndef CASE_FROM_H
#define CASE_FROM_H


#define from_CASE                                              \
	p += 4;                                                    \
	if (HAVE(1) && *p == '-') {                                \
		if (!HAVE(5))                                          \
			goto other;                                        \
		val = LOWER_DWORD(READ(p));                            \
		if (val == __pat_ && LOWER_BYTE(*(p+4)) == 'h') {      \
			hdr->type = HDR_FROM_PATH_T;                       \
			hdr->name.len = 9;                                 \
			p += 5;                                            \
			goto dc_cont;                                      \
		} else {                                               \
			goto other;                                        \
		}                                                      \
	} else {                                                   \
		hdr->type = HDR_FROM_T;                                \
		hdr->name.len = 4;                                     \
		goto dc_cont;                                          \
	}

#endif /* CASE_FROM_H */
