#
# OpenSIPS Presence Server configuration file
# Copyright (c) 2009 Voice System
# http://voice-system.ro

# ----------- global configuration parameters ------------------------
debug=3
log_stderror=no
log_facility=LOG_LOCAL1

fork=yes
children=8

sip_warning=no
check_via=no
dns=off
rev_dns=off
disable_tcp=yes
auto_aliases=no
disable_dns_blacklist = yes
dns_try_ipv6=no

listen=udp:MY_IP:MY_PORT

# Uncomment these lines to enter debugging mode 
#debug=7
#fork=no
#log_stderror=yes



# ------------------ module loading ----------------------------------

#set module path
mpath="/usr/local/opensips_presence/opensips/modules/"


loadmodule "sl.so"
loadmodule "tm.so"
loadmodule "signaling.so"
loadmodule "textops.so"
loadmodule "mi_xmlrpc.so"
loadmodule "db_mysql.so"
loadmodule "presence.so"
loadmodule "presence_xml.so"
loadmodule "mi_fifo.so"
loadmodule "uri.so"
loadmodule "pua.so"
loadmodule "pua_mi.so"

# ----------------- setting module-specific parameters ---------------

modparam("mi_fifo", "fifo_name", "/tmp/opensips_presence_fifo")
modparam("presence|presence_xml|pua", "db_url", "mysql://DB_USER:DB_PASSWD@DB_HOST/DB_NAME")
modparam("presence", "server_address", "sip:MY_IP:MY_PORT")
#modparam("presence_xml", "force_active", 1)
modparam("presence_xml", "integrated_xcap_server", 1)
modparam("mi_xmlrpc", "port", 8090)

# -------------------------  request routing logic -------------------

# main routing logic

route{

	# reject messages not from central SIP SERVER
	if(!src_ip==SERVER_IP || !src_port==SERVER_PORT)
	{
		exit;
	}

	# accept only PUBLISH or SUBSCRIBE methods
	if(!is_method("PUBLISH") && !is_method("SUBSCRIBE") )
	{
		exit;
	}

	# create new transaction to catch retransmissions
	if(!t_newtran())
	{
		sl_reply_error();
		exit;
	}	
	
	# handle presence specific messages
	if(is_method("PUBLISH"))
	{
		handle_publish();
	}
	else
	if(is_method("SUBSCRIBE"))
	{
		if (!uri_param("xcap")) {
			handle_subscribe("1");
		}else
			handle_subscribe();
	}

	exit;

}

